EvaluateScript("Layout.js");
EvaluateScript("Events.js");
EvaluateScript("Game.js");
EvaluateScript("Effects.js");
EvaluateScript("Menu.js");
EvaluateScript("Files.js");
EvaluateScript("Ability.js");
EvaluateScript("Submenu.js");
EvaluateScript("Item.js");
EvaluateScript("Enemy.js");
EvaluateScript("Battle.js");
EvaluateScript("Character.js");
EvaluateScript("Files.js");
EvaluateScript("Misc.js");
EvaluateScript("Tutorial.js");

var title = LoadImage("Title.png");
var Game = GameData();
Game.party[0] = Damizean;
Game.party[1] = Annika;

function CheckAccept()
{
	if (Game.area == true)
		Warp(Game.areamap);
}

function game()
{	
	var config = OpenFile("config.dat");
	if (config.read("CONFIG", false))
	{
		SetFrameRate(config.read("FPS", 10));
	}
	Game.psize = GetPartySize();
	FillIn();
	Game.money = 3000;
	var MainIntro = new Introduction(10);
	MainIntro.addEvent("Image", "Sphere.png", 3000);
	MainIntro.addEvent("Text", "Presents", 2000);
	MainIntro.addEvent("Text", "FALLACIOUS GEAR", 3000);
	MainIntro.play();
	var dmenu = new Menu(true);
	dmenu.addItem("Engine Test", GameTest);
	dmenu.addItem("Tutorial", Tutorial);
	dmenu.addItem("Exit");
	dmenu.items[1].enabled = false;
	ApplyColorMask(Colors.White);
	title.blit(GetScreenWidth() / 2 - title.width / 2, GetScreenHeight() / 2 - title.height / 2);
	ApplyColorMask(Colors.Shadow);
	dmenu.executeAlone(40, 40, 100, 3);
}

function GameTest()
{
	CreatePerson("Damizean", "Damizean.rss", false);
	BindKey(Game.menu, "OpenSubmenu()", "");
	BindKey(Game.accept, "CheckAccept()", "");
	AttachInput("Damizean");
	AttachCamera("Damizean");
	SetRenderScript("MapScript()");
	Game.location = "Elysian Field/ Sacred Grove 1F";
	Game.clock.start();
	MapEngine("Test.rmp", 60);
}